/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.util.CimXmlParser;
import com.ibm.hwmca.fw.util.Localizable;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMMethod;
import org.snia.wbem.cim.CIMParameter;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMQualifier;
import org.snia.wbem.cim.CIMValue;

public class ClassDescriptors {
    public static final String APPLICATION_QUALIFIER = "HWMCA_APPLICATION";
    public static final String CIM_APPLICATION = "CIM";
    public static final String MOMDEBUG_APPLICATION = "MOMDEBUG";
    public static final String PAGER_APPLICATION = "PAGER";
    public static final String SNMP_APPLICATION = "SNMP";
    public static final short XML_PARSE_ERR = 384;
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "ClassDesc");
    private static final String TRACE_MASKT = "XFRMCI T";
    private static final String TRACE_MASKF = "XFRMCI F";
    private static final String TRACE_MASKD = "XFRMCI D";
    private static Set allClassDescriptors = null;
    private Set classDescriptors = null;
    static /* synthetic */ Class class$java$net$InetAddress;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$Ljava$util$Date;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$Ljava$math$BigInteger;
    static /* synthetic */ Class array$Ljava$lang$String;

    private ClassDescriptors(Set classDescriptors) {
        Trace.trace(TRACE_MASKT, "<> ClassDescriptors(Set)");
        this.classDescriptors = classDescriptors;
    }

    public static ClassDescriptors getClassDescriptors() {
        Trace.trace(TRACE_MASKT, "<> getClassDescriptors()");
        return new ClassDescriptors(allClassDescriptors);
    }

    public Set getDescriptors() {
        Trace.trace(TRACE_MASKT, "<> getDescriptors()");
        return this.classDescriptors;
    }

    public static ClassDescriptors getClassDescriptors(String application) {
        Trace.trace(TRACE_MASKT, "-> getClassDescriptors(application=" + application + ")");
        HashSet<CIMClass> classDescriptors = new HashSet<CIMClass>();
        Iterator classIterator = allClassDescriptors.iterator();
        while (classIterator.hasNext()) {
            CIMClass aClass = (CIMClass)classIterator.next();
            CIMQualifier applQualifier = aClass.getQualifier(APPLICATION_QUALIFIER);
            if (applQualifier == null || !ClassDescriptors.containsAppl(applQualifier, application)) continue;
            Trace.trace(TRACE_MASKF, "Adding class: " + (aClass != null ? aClass.getName() : null));
            CIMClass newClass = new CIMClass();
            newClass.setIsKeyed(aClass.isKeyed());
            newClass.setName(aClass.getName());
            newClass.setQualifiers(aClass.getQualifiers());
            newClass.setSuperClass(aClass.getSuperClass());
            Vector methods = aClass.getAllMethods();
            Iterator iterator = methods.iterator();
            while (iterator.hasNext()) {
                CIMMethod method = (CIMMethod)iterator.next();
                applQualifier = method.getQualifier(APPLICATION_QUALIFIER);
                if (applQualifier == null || !ClassDescriptors.containsAppl(applQualifier, application)) continue;
                Trace.trace(TRACE_MASKF, "  Adding method: " + (method != null ? method.getName() : null));
                newClass.addMethod(method);
            }
            Vector properties = aClass.getAllProperties();
            Iterator iterator2 = properties.iterator();
            while (iterator2.hasNext()) {
                CIMProperty property = (CIMProperty)iterator2.next();
                applQualifier = property.getQualifier(APPLICATION_QUALIFIER);
                if (applQualifier == null || !ClassDescriptors.containsAppl(applQualifier, application)) continue;
                Trace.trace(TRACE_MASKF, "  Adding property: " + (property != null ? property.getName() : null));
                newClass.addProperty(property);
            }
            classDescriptors.add(newClass);
        }
        Trace.trace(TRACE_MASKT, "<- getClassDescriptors()");
        return new ClassDescriptors(classDescriptors);
    }

    public static boolean containsAppl(CIMQualifier qualifier, String application) {
        CIMValue cimValue;
        Trace.trace(TRACE_MASKT, "-> containsAppl(qualifier=" + (qualifier != null ? qualifier.getName() : null) + ", application=" + application + ")");
        boolean result = false;
        if (qualifier != null && (cimValue = qualifier.getValue()) != null) {
            if (cimValue.getValue() instanceof Vector) {
                Vector values = (Vector)cimValue.getValue();
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    String value = ((String)iterator.next()).trim();
                    if (!application.equalsIgnoreCase(value) && !value.equalsIgnoreCase("ALL")) continue;
                    result = true;
                    break;
                }
            } else if (cimValue.getValue() instanceof String) {
                String value = ((String)cimValue.getValue()).trim().toUpperCase();
                result = value.indexOf(application.toUpperCase()) >= 0 || value.equals("ALL");
            } else {
                Trace.trace(TRACE_MASKF, "CIMValue actually contained type: " + cimValue.getClass().getName());
            }
        }
        Trace.trace(TRACE_MASKT, "<- containsAppl(returns " + result + ")");
        return result;
    }

    public CIMClass findClass(String className) {
        Trace.trace(TRACE_MASKT, "-> findClass(className=" + className + ")");
        className = className.replace('$', '.');
        CIMClass result = null;
        Iterator iterator = this.classDescriptors.iterator();
        while (iterator.hasNext()) {
            CIMClass cimClass = (CIMClass)iterator.next();
            if (!cimClass.getName().equals(className)) continue;
            result = cimClass;
            break;
        }
        if (result == null) {
            try {
                Class<?> aClass = Class.forName(className);
                if (aClass != null && (aClass = aClass.getSuperclass()) != null) {
                    result = this.findClass(aClass.getName());
                }
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        Trace.trace(TRACE_MASKT, "<- findClass(returns " + (result == null ? "null" : result.getName()) + ")");
        return result;
    }

    public CIMClass findCimClass(String className) {
        Trace.trace(TRACE_MASKT, "-> findCimClass(className=" + className + ")");
        CIMClass result = null;
        Iterator iterator = this.classDescriptors.iterator();
        while (iterator.hasNext()) {
            CIMClass cimClass = (CIMClass)iterator.next();
            CIMQualifier nameQualifier = cimClass.getQualifier("HWMCA_CIMNAME");
            String cimClassName = null;
            if (nameQualifier == null) {
                cimClassName = cimClass.getName();
                int ix = cimClassName.lastIndexOf(46);
                if (ix >= 0) {
                    cimClassName = cimClassName.substring(ix + 1);
                }
                cimClassName = "IBMHWMCA_" + cimClassName;
            } else {
                cimClassName = (String)nameQualifier.getValue().getValue();
            }
            if (!cimClassName.equals(className)) continue;
            result = cimClass;
            break;
        }
        Trace.trace(TRACE_MASKT, "<- findCimClass(returns " + (result == null ? "null" : result.getName()) + ")");
        return result;
    }

    public CIMProperty findProperty(CIMClass cimClass, String propertyName) {
        Trace.trace(TRACE_MASKT, "-> findProperty(cimClass=" + (cimClass == null ? "null" : cimClass.getName()) + ", propertyName=" + propertyName + ")");
        CIMProperty result = null;
        if (cimClass != null) {
            int seperator = propertyName.indexOf(95);
            if (seperator != -1) {
                String nestedPropertyName = propertyName.substring(seperator + 1);
                String localPropertyName = propertyName.substring(0, seperator);
                CIMProperty localProperty = this.findProperty(cimClass, localPropertyName);
                CIMDataType type = localProperty.getType();
                if (!type.isReferenceType()) {
                    throw new IllegalStateException("A nested property name \"" + localPropertyName + "\" was found for a nonreference property");
                }
                CIMClass nestedClass = this.findClass(type.getRefClassName());
                if (nestedClass == null) {
                    throw new IllegalStateException("Nested property class name \"" + type.getRefClassName() + "\" was not found");
                }
                result = this.findProperty(nestedClass, nestedPropertyName);
                result.setName(localProperty.getName() + "_" + result.getName());
                result.setOriginClass(localProperty.getOriginClass());
            } else {
                result = cimClass.getProperty(propertyName);
                if (result == null) {
                    result = this.findProperty(this.findClass(cimClass.getSuperClass()), propertyName);
                }
                if (result != null) {
                    result = (CIMProperty)result.clone();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- findProperty(returns " + (result == null ? "null" : result.getName()) + ")");
        return result;
    }

    public CIMMethod findMethod(CIMClass cimClass, String methodName) {
        return this.findMethod(cimClass, methodName, null, null);
    }

    private CIMMethod findMethod(CIMClass cimClass, String methodName, String qualifierName, String qualifierValue) {
        Trace.trace(TRACE_MASKF, "-> findMethod(cimClass=" + (cimClass == null ? "null" : cimClass.getName()) + ", methodName=" + methodName + ", qualifierName=" + qualifierName + ", qualifierValue=" + qualifierValue + ")");
        CIMMethod result = null;
        if (cimClass != null) {
            int seperator = methodName.indexOf(95);
            if (seperator != -1) {
                String nestedMethodName = methodName.substring(seperator + 1);
                String localPropertyName = methodName.substring(0, seperator);
                CIMProperty localProperty = cimClass.getProperty(localPropertyName);
                if (localProperty == null) {
                    result = this.findMethod(this.findClass(cimClass.getSuperClass()), methodName, qualifierName, qualifierValue);
                } else {
                    CIMDataType type = localProperty.getType();
                    if (!type.isReferenceType()) {
                        throw new IllegalStateException("A nested property name \"" + localPropertyName + "\" was found for a nonreference property");
                    }
                    CIMClass nestedClass = this.findClass(type.getRefClassName());
                    if (nestedClass == null) {
                        throw new IllegalStateException("Nested property class name \"" + type.getRefClassName() + "\" was not found");
                    }
                    result = this.findMethod(nestedClass, nestedMethodName, qualifierName, qualifierValue);
                }
                result.setName(localPropertyName + "_" + result.getName());
            } else {
                result = cimClass.getMethod(methodName);
                if (result == null && qualifierName != null && qualifierValue != null) {
                    Vector methods = cimClass.getAllMethods();
                    Iterator iterator = methods.iterator();
                    while (iterator.hasNext()) {
                        CIMMethod method = (CIMMethod)iterator.next();
                        CIMQualifier qualifier = method.getQualifier(qualifierName);
                        if (qualifier == null || !((String)qualifier.getValue().getValue()).trim().equalsIgnoreCase(qualifierValue)) continue;
                        result = method;
                        break;
                    }
                }
                if (result == null) {
                    result = this.findMethod(this.findClass(cimClass.getSuperClass()), methodName, qualifierName, qualifierValue);
                }
                if (result != null) {
                    result = (CIMMethod)result.clone();
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- findMethod(returns " + (result == null ? "null" : result.getName()) + ")");
        return result;
    }

    public CIMMethod findGetMethod(CIMProperty property) {
        CIMMethod result = null;
        if (property != null) {
            CIMClass cimClass = this.findClass(property.getOriginClass());
            result = this.findGetMethod(cimClass, property);
        }
        return result;
    }

    public CIMMethod findGetMethod(CIMClass cimClass, CIMProperty property) {
        Trace.trace(TRACE_MASKF, "-> findGetMethod(cimClass=" + cimClass.getName() + ",property=" + property + ")");
        String prefix = null;
        String propertyName = property.getName();
        int seperator = propertyName.lastIndexOf(95);
        if (seperator != -1) {
            prefix = propertyName.substring(0, seperator + 1);
            propertyName = propertyName.substring(seperator + 1);
        }
        String methodName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        methodName = property.getType().getType() == 10 ? "is" + methodName : "get" + methodName;
        if (prefix != null) {
            methodName = prefix + methodName;
        }
        CIMMethod result = this.findMethod(cimClass, methodName, "HWMCA_GETMETHODFOR", propertyName);
        Trace.trace(TRACE_MASKF, "<- findGetMethod(returns " + (result == null ? "null" : result.getName()) + ")");
        return result;
    }

    public CIMMethod findSetMethod(CIMProperty property) {
        CIMClass cimClass = this.findClass(property.getOriginClass());
        return this.findSetMethod(cimClass, property);
    }

    public CIMMethod findSetMethod(CIMClass cimClass, CIMProperty property) {
        Trace.trace(TRACE_MASKF, "-> findSetMethod(cimClass=" + cimClass.getName() + ",property=" + property + ")");
        String prefix = null;
        String propertyName = property.getName();
        int seperator = propertyName.lastIndexOf(95);
        if (seperator != -1) {
            prefix = propertyName.substring(0, seperator + 1);
            propertyName = propertyName.substring(seperator);
        }
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        if (prefix != null) {
            methodName = prefix + methodName;
        }
        CIMMethod result = this.findMethod(cimClass, methodName, "HWMCA_SETMETHODFOR", propertyName);
        Trace.trace(TRACE_MASKF, "<- findSetMethod(returns " + (result == null ? "null" : result.getName()) + ")");
        return result;
    }

    public Object invokeMethod(CIMMethod method, Object instance, Object[] parms) throws NoSuchMethodException, Throwable {
        Trace.trace(TRACE_MASKT, "-> invokeMethod(method=" + method.getName() + ")");
        Trace.trace(TRACE_MASKD, "instance=" + instance);
        Trace.trace(TRACE_MASKD, "parms=" + parms);
        if (parms != null) {
            int ix = 0;
            while (ix < parms.length) {
                Trace.trace(TRACE_MASKD, "parm[" + ix + "]=" + parms[ix] + ")");
                ++ix;
            }
        }
        Object result = null;
        String name = method.getName();
        int seperator = name.indexOf(95);
        if (seperator != -1) {
            String nestedMethodName = name.substring(seperator + 1);
            String localPropertyName = name.substring(0, seperator);
            CIMClass instanceClass = this.findClass(instance.getClass().getName());
            if (instanceClass == null) {
                throw new IllegalStateException("Class " + instanceClass.getClass().getName() + " not found");
            }
            CIMProperty localProperty = this.findProperty(instanceClass, localPropertyName);
            if (localProperty == null) {
                throw new IllegalStateException("Property " + localPropertyName + " not found");
            }
            CIMMethod localPropertyGetMethod = this.findGetMethod(localProperty);
            if (localPropertyGetMethod == null) {
                throw new IllegalStateException("An accessor method does not exist for property " + localPropertyName);
            }
            Object localPropertyValue = this.invokeMethod(localPropertyGetMethod, instance, null);
            if (localPropertyValue.getClass().isArray()) {
                CIMMethod nestedMethod = (CIMMethod)method.clone();
                nestedMethod.setName(nestedMethodName);
                ArrayList<Object> resultValues = new ArrayList<Object>();
                int ix = 0;
                while (ix < ((Object[])localPropertyValue).length) {
                    resultValues.add(this.invokeMethod(nestedMethod, ((Object[])localPropertyValue)[ix], parms));
                    ++ix;
                }
                if (resultValues.size() > 0) {
                    result = Array.newInstance(resultValues.get(0).getClass(), resultValues.size());
                    resultValues.toArray((T[])result);
                } else {
                    result = resultValues.toArray();
                }
            } else {
                CIMMethod nestedMethod = (CIMMethod)method.clone();
                nestedMethod.setName(nestedMethodName);
                result = this.invokeMethod(nestedMethod, localPropertyValue, parms);
            }
        } else {
            Vector qualifiers = method.getQualifiers();
            Vector parameters = method.getParameters();
            ArrayList<Class> parmTypes = new ArrayList<Class>();
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                CIMParameter parm = (CIMParameter)iterator.next();
                CIMQualifier inQualifier = parm.getQualifier("IN");
                if (inQualifier == null || inQualifier.getValue() != null && !((String)inQualifier.getValue().getValue()).trim().equalsIgnoreCase("true")) continue;
                parmTypes.add(ClassDescriptors.toJavaType(parm));
            }
            int parameterCnt = parmTypes.size();
            if ((parms != null || parameterCnt != 0) && parms != null && parms.length != parameterCnt) {
                throw new IllegalArgumentException("Defined parameter count (" + parameterCnt + ") does not equal the supplied parameter count (" + parms.length + ")");
            }
            Class<?> instanceClass = instance.getClass();
            Class[] parmClasses = new Class[parameterCnt];
            parmTypes.toArray(parmClasses);
            Method instanceMethod = this.lookupMethod(instanceClass, name, parmClasses);
            instanceMethod.setAccessible(true);
            try {
                result = instanceMethod.invoke(instance, parms);
            }
            catch (InvocationTargetException exc) {
                throw exc.getTargetException();
            }
        }
        Trace.trace(TRACE_MASKT, "<- invokeMethod(returns " + result + ")");
        return result;
    }

    public void setPropertyValue(CIMProperty property, Object instance, String newValue) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> setPropertyValue(property=" + property + ")");
        Trace.trace(TRACE_MASKD, "instance=" + instance);
        Trace.trace(TRACE_MASKD, "newValue=" + newValue);
        CIMQualifier cimQualifier = property.getQualifier("HWMCA_READONLY");
        if (cimQualifier != null && ClassDescriptors.containsAppl(cimQualifier, MOMDEBUG_APPLICATION)) {
            throw new IllegalStateException("Property " + property.getName() + " is readonly");
        }
        CIMMethod method = this.findSetMethod(property);
        if (method == null) {
            throw new IllegalStateException("Property " + property.getName() + " has no set method");
        }
        Object value = newValue;
        if (newValue.equals("<null>")) {
            value = null;
        } else if (property.getType().isReferenceType()) {
            Class<?> refClass;
            if ((class$java$net$InetAddress == null ? (class$java$net$InetAddress = ClassDescriptors.class$("java.net.InetAddress")) : class$java$net$InetAddress).isAssignableFrom(refClass = Class.forName(property.getType().getRefClassName()))) {
                value = InetAddress.getByName(newValue);
            } else {
                Constructor<?> ctor = refClass.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = ClassDescriptors.class$("java.lang.String")) : class$java$lang$String);
                value = ctor.newInstance(newValue);
            }
        } else {
            int type = property.getType().getType();
            if (type != 9) {
                if (type == 10) {
                    value = new Boolean(newValue);
                } else if (type == 8 || type == 5) {
                    value = new Long(newValue);
                } else if (type == 6 || type == 3) {
                    value = new Integer(newValue);
                } else if (type == 4 || type == 1) {
                    value = new Short(newValue);
                } else if (type == 2) {
                    value = new Byte(newValue);
                } else if (type == 7) {
                    value = new BigInteger(newValue);
                } else if (type == 14) {
                    value = new Character(newValue.charAt(0));
                } else if (type == 12) {
                    value = new Double(newValue.charAt(0));
                } else if (type == 11) {
                    value = new Float(newValue.charAt(0));
                }
            }
        }
        Trace.trace(TRACE_MASKF, "Setting value of type " + (value == null ? "null" : value.getClass().getName()));
        this.invokeMethod(method, instance, new Object[]{value});
        Trace.trace(TRACE_MASKT, "<- setPropertyValue()");
    }

    public String getPropertyValue(CIMProperty property, Object instance) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> getPropertyValue(property=" + property + ")");
        Trace.trace(TRACE_MASKD, "instance=" + instance);
        CIMMethod method = this.findGetMethod(property);
        Object result = this.invokeMethod(method, instance, null);
        if (result instanceof Localizable) {
            result = ((Localizable)result).toUnlocalizedString();
        } else if (result instanceof InetAddress) {
            result = ((InetAddress)result).getHostAddress();
        } else if (result != null) {
            result = result.toString();
        }
        Trace.trace(TRACE_MASKT, "<- getPropertyValue(returns " + result + ")");
        return (String)result;
    }

    public static Vector filterQualifiers(Vector qualifiers) {
        Vector<CIMQualifier> result = new Vector<CIMQualifier>();
        Iterator iterator = qualifiers.iterator();
        while (iterator.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iterator.next();
            String name = qualifier.getName();
            if (name.startsWith("HWMCA_")) continue;
            result.add(qualifier);
        }
        return result;
    }

    private static Class toJavaType(CIMParameter parameter) {
        CIMDataType type = parameter.getType();
        int intType = type.getType();
        String referenceType = null;
        if (intType == 41) {
            referenceType = type.getRefClassName();
        }
        return ClassDescriptors.toJavaType(intType, referenceType);
    }

    private static Class toJavaType(int type, String referenceType) {
        Class result = null;
        switch (type) {
            case 10: {
                result = Boolean.TYPE;
                break;
            }
            case 14: {
                result = Character.TYPE;
                break;
            }
            case 13: {
                result = class$java$util$Date == null ? (class$java$util$Date = ClassDescriptors.class$("java.util.Date")) : class$java$util$Date;
                break;
            }
            case 11: {
                result = Float.TYPE;
                break;
            }
            case 12: {
                result = Double.TYPE;
                break;
            }
            case 41: {
                if (referenceType == null) {
                    throw new IllegalArgumentException("Missing REFERENCE_TYPE qualifier for REFERENCE data type");
                }
                try {
                    result = Class.forName(referenceType);
                    break;
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException("Cannot resolve class for '" + referenceType + "'");
                }
            }
            case 2: {
                result = Byte.TYPE;
                break;
            }
            case 1: 
            case 4: {
                result = Short.TYPE;
                break;
            }
            case 3: 
            case 6: {
                result = Integer.TYPE;
                break;
            }
            case 5: 
            case 8: {
                result = Long.TYPE;
                break;
            }
            case 7: {
                result = class$java$math$BigInteger == null ? (class$java$math$BigInteger = ClassDescriptors.class$("java.math.BigInteger")) : class$java$math$BigInteger;
                break;
            }
            case 9: {
                result = class$java$lang$String == null ? (class$java$lang$String = ClassDescriptors.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 30: {
                result = array$Z == null ? (array$Z = ClassDescriptors.class$("[Z")) : array$Z;
                break;
            }
            case 34: {
                result = array$C == null ? (array$C = ClassDescriptors.class$("[C")) : array$C;
                break;
            }
            case 33: {
                result = array$Ljava$util$Date == null ? (array$Ljava$util$Date = ClassDescriptors.class$("[Ljava.util.Date;")) : array$Ljava$util$Date;
                break;
            }
            case 31: {
                result = array$F == null ? (array$F = ClassDescriptors.class$("[F")) : array$F;
                break;
            }
            case 32: {
                result = array$D == null ? (array$D = ClassDescriptors.class$("[D")) : array$D;
                break;
            }
            case 22: {
                result = array$B == null ? (array$B = ClassDescriptors.class$("[B")) : array$B;
                break;
            }
            case 21: 
            case 24: {
                result = array$S == null ? (array$S = ClassDescriptors.class$("[S")) : array$S;
                break;
            }
            case 23: 
            case 26: {
                result = array$I == null ? (array$I = ClassDescriptors.class$("[I")) : array$I;
                break;
            }
            case 25: 
            case 28: {
                result = array$J == null ? (array$J = ClassDescriptors.class$("[J")) : array$J;
                break;
            }
            case 27: {
                result = array$Ljava$math$BigInteger == null ? (array$Ljava$math$BigInteger = ClassDescriptors.class$("[Ljava.math.BigInteger;")) : array$Ljava$math$BigInteger;
                break;
            }
            case 29: {
                Class clazz = result = array$Ljava$lang$String == null ? (array$Ljava$lang$String = ClassDescriptors.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unsupported CIMDataType: " + type);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private Method lookupMethod(Class aClass, String name, Class[] parmTypes) throws NoSuchMethodException {
        result = null;
        while (aClass != null) {
            block4: {
                block5: {
                    try {
                        result = aClass.getDeclaredMethod(name, parmTypes);
                        break;
                    }
                    catch (NoSuchMethodException exc) {
                        aClass = aClass.getSuperclass();
                        if (aClass != null) break block4;
                        Trace.trace("XFRMCI F", "name=" + name);
                        if (parmTypes == null) break block5;
                        ix = 0;
                        ** while (ix < parmTypes.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        Trace.trace("XFRMCI F", "parmTypes[" + ix + "]=" + parmTypes[ix]);
                        ++ix;
                        continue;
                    }
                }
                throw exc;
            }
            result = this.lookupMethod(aClass, name, parmTypes);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            CimXmlParser parser = new CimXmlParser();
            allClassDescriptors = parser.discoverXml();
        }
        catch (Exception exc) {
            new FrameworkLog(logInfo, 384, exc).log(LogAttributes.INFO_LOG);
        }
    }
}

